<?php 
@session_start();
require("../../../conexao.php");

$id_conta = filter_var($_GET['id'], @FILTER_SANITIZE_STRING);

$query = $pdo->prepare("SELECT * FROM receber where id = :id_conta");
$query->bindValue(":id_conta", "$id_conta");
$query->execute();
$res = $query->fetchAll(PDO::FETCH_ASSOC);
$total_reg = @count($res);
if ($total_reg > 0) {
    $cliente = $res[0]['cliente'];
    $descricao = $res[0]['descricao'];
    $valor = $res[0]['valor'];
    $ref_pix = $res[0]['ref_pix'];
    $data = $res[0]['data_lanc'];
    $hora = $res[0]['hora'];
    $dataF = implode('/', array_reverse(explode('-', $data)));
    $horaF = date("H:i", strtotime($hora));
    $id_empresa = $res[0]['empresa'];
    $_SESSION['id_empresa'] = $id_empresa;
    $vencimento = $res[0]['vencimento'];
}

$query2 = $pdo->query("SELECT * FROM clientes where id = '$cliente'");
$res2 = $query2->fetchAll(PDO::FETCH_ASSOC);

// Campos com verificação e preenchimento fictício caso estejam vazios
$nome = !empty($res2[0]['nome']) ? $res2[0]['nome'] : 'Cliente Padrão';
$cpf = !empty($res2[0]['cpf']) ? $res2[0]['cpf'] : '768.344.690-44'; // CPF genérico (11 dígitos)
$email = !empty($res2[0]['email']) ? $res2[0]['email'] : 'cliente@email.com';
$telefone = !empty($res2[0]['telefone']) ? $res2[0]['telefone'] : '31995348111'; // Ex: número fictício com DDD
$cep = !empty($res2[0]['cep']) ? $res2[0]['cep'] : '74000000'; // CEP genérico
$rua = !empty($res2[0]['endereco']) ? $res2[0]['endereco'] : 'Rua Padrão';
$numero = !empty($res2[0]['numero']) ? $res2[0]['numero'] : '0';
$complemento = !empty($res2[0]['complemento']) ? $res2[0]['complemento'] : '';
$bairro = !empty($res2[0]['bairro']) ? $res2[0]['bairro'] : 'Centro';
$cidade = !empty($res2[0]['cidade']) ? $res2[0]['cidade'] : 'Goiânia';
$estado = !empty($res2[0]['estado']) ? $res2[0]['estado'] : 'GO';

// Cálculo de multa e juros
$valor_multa = 0;
$valor_juros = 0;
$data_hoje = date('Y-m-d');
if (@strtotime($vencimento) < @strtotime($data_hoje)) {
    $valor_multa = $multa_atraso;

    // Calcular a quantidade de dias de atraso
    $dif = @strtotime($data_hoje) - @strtotime($vencimento);
    $dias_vencidos = floor($dif / (60 * 60 * 24));

    // Calcular juros
    $valor_juros = ($valor * $juros_atraso / 100) * $dias_vencidos;
}

$total = $valor_multa + $valor_juros + $valor;
$valor_multa_juros = $valor_multa + $valor_juros;

require("configApi.php");

// Cadastra o cliente na API do Asaas
$cliente_data = [
    'name' => $nome,
    'cpfCnpj' => $cpf,
    'email' => $email,
    'phone' => $telefone,
    'mobilePhone' => $telefone,
    'address' => $rua,
    'addressNumber' => $numero,
    'complement' => $complemento,
    'province' => $bairro,
    'postalCode' => $cep
];

// Verifica se já tem um customer salvo no banco, se quiser pode adaptar para checar isso antes
$ch = curl_init();
curl_setopt_array($ch, [
    CURLOPT_URL => 'https://api.asaas.com/v3/customers',
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_POST => true,
    CURLOPT_POSTFIELDS => json_encode($cliente_data),
    CURLOPT_HTTPHEADER => [
        'Content-Type: application/json',
        'User-agent: MeuSistema/1.0',
        'access_token: ' . $access_token
    ]
]);
$resposta_cliente = curl_exec($ch);
curl_close($ch);

$res_cliente = json_decode($resposta_cliente);
$customer_id = $res_cliente->id ?? null;

if (!$customer_id) {
    echo "<div class='alert alert-danger'><b>Erro ao cadastrar cliente na Asaas:</b> " . $resposta_cliente . "</div>";
    exit();
}

// ✅ Agora com o ID do cliente, geramos a cobrança (sem QR Code ainda)
$dados_pagamento = [
    'customer' => $customer_id,
    'billingType' => 'PIX',
    'value' => floatval($total),
    'dueDate' => $data_hoje, // ou usar $vencimento, se desejar
    'description' => $descricao
];

// Geração do pagamento via PIX
$curl = curl_init();
curl_setopt_array($curl, [
    CURLOPT_URL => 'https://api.asaas.com/v3/payments',
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_CUSTOMREQUEST => 'POST',
    CURLOPT_POSTFIELDS => json_encode($dados_pagamento),
    CURLOPT_HTTPHEADER => [
        'accept: application/json',
        'content-type: application/json',
        'User-agent: MeuSistema/1.0',
        'access_token: ' . $access_token
    ]
]);

$response = curl_exec($curl);
curl_close($curl);

$resultado = json_decode($response);

// Verifica se deu erro
if (isset($resultado->errors)) {
    echo "<div class='alert alert-danger'><b>Erro ao gerar o PIX:</b><br>";
    foreach ($resultado->errors as $error) {
        echo $error->description . ' (' . $error->code . ')<br>';
    }
    echo "</div>";
    exit();
} elseif (!isset($resultado->id)) {
    echo "<div class='alert alert-danger'><b>Erro desconhecido ao gerar o PIX:</b> $response</div>";
    exit();
}

// Atualiza a conta com o ref_pix (id do pagamento)
$pdo->query("UPDATE receber SET ref_pix = '$resultado->id' where id = '$id_conta'");

// Agora que temos o ID do pagamento, recuperamos o QR Code
$curl = curl_init();
curl_setopt_array($curl, [
    CURLOPT_URL => 'https://api.asaas.com/v3/payments/' . $resultado->id . '/pixQrCode',
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_HTTPHEADER => [
        'accept: application/json',
        'User-agent: MeuSistema/1.0',
        'access_token: ' . $access_token
    ]
]);

$qrCodeResponse = curl_exec($curl);
curl_close($curl);

$qrCodeResult = json_decode($qrCodeResponse);
$qrCodeImage = $qrCodeResult->pixQrCode ?? null;

// Verifica se o QR Code foi retornado corretamente
$qrCodeImage = $qrCodeResult->encodedImage ?? null;

if (!$qrCodeImage) {
    echo "<div class='alert alert-danger'><b>Erro ao recuperar o QR Code:</b> " . $qrCodeResponse . "</div>";
    exit();
}
?>

<!-- EXIBE O QRCODE DO PIX -->
<div class="row">
    <div class="col-lg-3"></div>
    <div class="col-lg-6">
        <h4 class="text-center"><?php echo $descricao ?></h4>
        <p class="text-center">Total a pagar R$ <?php echo number_format($total, 2, ',', '.');?></p>
        <hr>
        <center>
            <!-- Exibe a imagem do QR Code em Base64 -->
            <img style='display:block; width: 70%;' id='base64image' src='data:image/png;base64, <?php echo $qrCodeImage; ?>' />
            <hr>
            <button id="copyButton" class="btn btn-primary">Copia e Cola</button>
            <textarea id="pixCode" style="position: absolute; left: -9999px;"><?php echo $qrCodeResult->payload; ?></textarea>
        </center>
    </div>
</div>

<script>
    // CÓDIGO PARA COPIAR PIX
    document.getElementById('copyButton').addEventListener('click', function() {
        var textArea = document.getElementById('pixCode');
        textArea.select();
        navigator.clipboard.writeText(textArea.value).then(function() {
            alert('Código PIX copiado com sucesso!');
        }, function(err) {
            console.error('Erro ao copiar: ', err);
            alert('Não foi possível copiar o código PIX.');
        });
    });
</script>